/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.impl;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.lib.Fluids;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.api.Gidable;
import org.jwaresoftware.mcmods.lib.api.IModBlock;
import org.jwaresoftware.mcmods.lib.api.IMultiTextured;
import org.jwaresoftware.mcmods.lib.api.mod.IModInfo;
import org.jwaresoftware.mcmods.lib.api.mod.IModInventoryRenderingHelper;

@SideOnly(value=Side.CLIENT)
public abstract class ModInventoryModelHelperBase
implements IModInventoryRenderingHelper {
    protected final IModInfo _modinfo;

    protected ModInventoryModelHelperBase(@Nonnull IModInfo modinfo) {
        Validate.notNull((Object)modinfo);
        this._modinfo = modinfo;
    }

    protected final String mod_id() {
        return this._modinfo.mod_id();
    }

    protected ResourceLocation mod_resource(String id) {
        return new ResourceLocation(this.mod_id(), id);
    }

    protected final Item findItem_(String oid) {
        return (Item)GameRegistry.findRegistry(Item.class).getValue(this.mod_resource(oid));
    }

    protected final Item findBlock_(String oid) {
        Block block = (Block)GameRegistry.findRegistry(Block.class).getValue(this.mod_resource(oid));
        return block == null ? Items.field_190931_a : Item.func_150898_a((Block)block);
    }

    protected final Block findBlockonly_(String oid) {
        return (Block)GameRegistry.findRegistry(Block.class).getValue(this.mod_resource(oid));
    }

    private void checkNonrenderingBlockProperties(Block singleton) {
        IProperty<?>[] properties;
        if (singleton instanceof IModBlock && (properties = ((IModBlock)singleton).getNonRenderingProperties()) != null) {
            StateMap custom_mapper = new StateMap.Builder().func_178442_a(properties).func_178441_a();
            ModelLoader.setCustomStateMapper((Block)singleton, (IStateMapper)custom_mapper);
        }
    }

    @Override
    public final void doRenderSetupOrFail(String oid, Item singleton) {
        if (singleton instanceof IMultiTextured) {
            String[] fmlids = ((IMultiTextured)singleton).getInventoryRenderingNames();
            int[] metas = ((IMultiTextured)singleton).getInventoryRenderingMetas();
            this.doRenderSetupOrFail(oid, singleton, fmlids, metas);
        } else {
            String subdir;
            Item registered = this.findItem_(oid);
            Validate.validState((boolean)SharedGlue.isDefined(registered), (String)"Mod item '%s' not registered with MC+FML runtimes (cached name=%s)", (Object[])new Object[]{oid, singleton.func_77658_a()});
            if (singleton instanceof Gidable && (subdir = ((Gidable)singleton).gid(singleton)) != null && !subdir.isEmpty()) {
                oid = subdir + "/" + oid;
            }
            ModelResourceLocation model = new ModelResourceLocation(this.mod_id() + ":" + oid, "inventory");
            ModelLoader.setCustomModelResourceLocation((Item)singleton, (int)0, (ModelResourceLocation)model);
        }
    }

    @Override
    public final void doRenderSetupOrFail(String oid, Block singleton) {
        if (singleton instanceof IMultiTextured) {
            String[] fmlids = ((IMultiTextured)singleton).getInventoryRenderingNames();
            int[] metas = ((IMultiTextured)singleton).getInventoryRenderingMetas();
            this.doRenderSetupOrFail(oid, singleton, fmlids, metas);
        } else {
            String subdir;
            Item registered = this.findBlock_(oid);
            Validate.validState((boolean)SharedGlue.isDefined(registered), (String)"Mod block '%s' not registered with MC+FML runtimes (cached name=%s)", (Object[])new Object[]{oid, singleton.func_149739_a()});
            this.checkNonrenderingBlockProperties(singleton);
            if (singleton instanceof Gidable && (subdir = ((Gidable)singleton).gid(singleton)) != null && !subdir.isEmpty()) {
                oid = subdir + "/" + oid;
            }
            ModelResourceLocation model = new ModelResourceLocation(this.mod_id() + ":" + oid, "inventory");
            ModelLoader.setCustomModelResourceLocation((Item)registered, (int)0, (ModelResourceLocation)model);
        }
    }

    @Override
    public final void doRenderSetupOrFail(String oid, Item singleton, String[] fmlids, int[] metas) {
        Validate.validState((fmlids != null && metas != null ? 1 : 0) != 0, (String)"A valid set of meta information is required", (Object[])new Object[0]);
        Item registered = this.findItem_(oid);
        Validate.validState((boolean)SharedGlue.isDefined(registered), (String)"Mod multi-x item '%s' not registered with MC+FML runtimes (cached name=%s)", (Object[])new Object[]{oid, singleton.func_77658_a()});
        if (fmlids.length > 1) {
            for (int index = 0; index < metas.length; ++index) {
                ModelResourceLocation model = new ModelResourceLocation(fmlids[index], "inventory");
                ModelLoader.setCustomModelResourceLocation((Item)singleton, (int)metas[index], (ModelResourceLocation)model);
            }
        } else {
            ModelResourceLocation model = new ModelResourceLocation(this.mod_id() + ":" + fmlids[0], "inventory");
            for (int index = 0; index < metas.length; ++index) {
                ModelLoader.setCustomModelResourceLocation((Item)singleton, (int)metas[index], (ModelResourceLocation)model);
            }
        }
    }

    @Override
    public final void doRenderSetupOrFail(String oid, Block singleton, String[] fmlids, int[] metas) {
        Validate.validState((fmlids != null && metas != null ? 1 : 0) != 0, (String)"A valid set of meta information is required", (Object[])new Object[0]);
        Item registered = this.findBlock_(oid);
        Validate.validState((boolean)SharedGlue.isDefined(registered), (String)"Mod multi-x block '%s' not registered with MC+FML runtimes (cached name=%s)", (Object[])new Object[]{oid, singleton.func_149739_a()});
        this.checkNonrenderingBlockProperties(singleton);
        if (fmlids.length > 1) {
            for (int index = 0; index < metas.length; ++index) {
                ModelResourceLocation model = new ModelResourceLocation(fmlids[index], "inventory");
                ModelLoader.setCustomModelResourceLocation((Item)registered, (int)metas[index], (ModelResourceLocation)model);
            }
        } else {
            ModelResourceLocation model = new ModelResourceLocation(this.mod_id() + ":" + fmlids[0], "inventory");
            for (int index = 0; index < metas.length; ++index) {
                ModelLoader.setCustomModelResourceLocation((Item)registered, (int)metas[index], (ModelResourceLocation)model);
            }
        }
    }

    @Override
    public final void doRenderFluidOrFail(String oid, Block singleton, Fluid fluid) {
        Block registered = this.findBlockonly_(oid);
        Validate.validState((registered != null ? 1 : 0) != 0, (String)"Mod fluid (block) '%s' not registered with MC+FML runtimes (cached name=%s)", (Object[])new Object[]{oid, singleton.func_149739_a()});
        Fluids.StateMapper mapper = new Fluids.StateMapper(this.mod_id(), fluid, true);
        ModelLoader.setCustomStateMapper((Block)registered, (IStateMapper)mapper);
        Item item = Item.func_150898_a((Block)registered);
        if (SharedGlue.isDefined(item)) {
            ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[0]);
            ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)mapper);
        }
    }
}

